/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.playvk;

import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import ru.curoviyxru.j2vk.api.objects.attachments.Audio;
import ru.curoviyxru.phoenix.midlet.Midlet;
import ru.curoviyxru.phoenix.ui.FilePicker;
import ru.curoviyxru.playvk.PlayerWrapper;

public class AudioCache {
    public static boolean folderExists() {
        return PlayerWrapper.folderExists(Midlet.instance.config.caching_folder);
    }

    public static String get(Audio audio) {
        if (audio == null || !AudioCache.folderExists()) {
            return null;
        }
        String string = Midlet.instance.config.caching_folder;
        if (!string.endsWith(FilePicker.SEPARATOR)) {
            string = string + FilePicker.SEPARATOR;
        }
        string = string + AudioCache.getName(audio) + ".mp3";
        return string;
    }

    public static boolean has(Audio audio) {
        if (audio == null || !AudioCache.folderExists()) {
            return false;
        }
        String string = AudioCache.get(audio);
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)string, (int)1);
            boolean bl = fileConnection.exists() && fileConnection.canRead();
            fileConnection.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getName(Audio audio) {
        if (audio == null) {
            return null;
        }
        String string = AudioCache.cleanNLimit(audio.artist) + " - " + AudioCache.cleanNLimit(audio.title) + " - " + AudioCache.getID(audio);
        if (string.length() <= 46) {
            return string;
        }
        string = AudioCache.cleanNLimit(audio.title) + " - " + AudioCache.getID(audio);
        if (string.length() <= 46) {
            return string;
        }
        return AudioCache.getID(audio);
    }

    private static String getID(Audio audio) {
        return AudioCache.toDAE(audio.owner_id) + "_" + AudioCache.toDAE(audio.id);
    }

    private static String cleanNLimit(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 20) {
            stringBuffer.setLength(20);
        }
        return stringBuffer.toString().trim();
    }

    public static String toDAE(long l) {
        if (l == 0L) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = l < 0L;
        for (l = Math.abs(l); l > 0L; l /= 62L) {
            long l2 = l % 62L;
            if (l2 < 10L) {
                stringBuffer.append((char)(48L + l2));
                continue;
            }
            if (l2 < 36L) {
                stringBuffer.append((char)(97L + l2 - 10L));
                continue;
            }
            stringBuffer.append((char)(65L + l2 - 36L));
        }
        if (bl) {
            stringBuffer.append('-');
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }
}

