/*
 * Decompiled with CFR 0.152.
 */
package ru.curoviyxru.playvk;

import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import ru.curoviyxru.j2vk.HTTPClient;
import ru.curoviyxru.j2vk.ProgressProvider;
import ru.curoviyxru.playvk.PlayerContent;

public class PlayerWrapper
implements PlayerListener {
    Player p;
    int volume = 100;
    VolumeControl vc;
    PlayerContent pc;
    int pauseTime = -1;
    private static String mp3Type;
    private static Boolean hasHTTPS;

    public PlayerWrapper(PlayerContent playerContent) {
        this.pc = playerContent;
    }

    public void setVolume(int n) {
        this.volume = Math.max(0, Math.min(100, n));
        if (this.vc == null) {
            return;
        }
        this.vc.setLevel(this.volume);
    }

    public void playerUpdate(Player player, String string, Object object) {
        this.pc.update();
        if (string.equals("endOfMedia")) {
            this.pc.endOfMedia();
        }
    }

    public void stop() {
        if (this.p == null) {
            return;
        }
        this.pauseTime = -1;
        try {
            this.p.close();
            this.p = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public void play() {
        if (this.p == null) {
            return;
        }
        try {
            if (this.pauseTime != -1) {
                this.p.setMediaTime((long)this.pauseTime);
            }
            this.setVolume(this.volume);
            this.p.start();
            if (this.pauseTime != -1) {
                this.p.setMediaTime((long)this.pauseTime);
            }
            this.pauseTime = -1;
        }
        catch (MediaException mediaException) {
            this.stop();
        }
    }

    public void pause() {
        if (this.p == null) {
            return;
        }
        try {
            this.pauseTime = this.getTime();
            this.p.stop();
        }
        catch (MediaException mediaException) {
            this.stop();
        }
    }

    public int setTime(int n) {
        if (this.p == null) {
            return -1;
        }
        try {
            long l;
            if (this.pauseTime != -1) {
                this.pauseTime = n;
            }
            return (l = this.p.setMediaTime((long)(n * 1000000))) == -1L ? -1 : (int)(l / 1000000L);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getTime() {
        if (this.p == null) {
            return -1;
        }
        try {
            if (this.pauseTime != -1) {
                return this.pauseTime;
            }
            long l = this.p.getMediaTime();
            return l == -1L ? -1 : (int)(l / 1000000L);
        }
        catch (Exception exception) {
            this.stop();
            return -1;
        }
    }

    public int getDuration() {
        if (this.p == null) {
            return -1;
        }
        try {
            long l = this.p.getDuration();
            return l == -1L ? -1 : (int)(l / 1000000L);
        }
        catch (Exception exception) {
            this.stop();
            return -1;
        }
    }

    public void set(InputConnection inputConnection) {
        this.stop();
        try {
            this.p = Manager.createPlayer((InputStream)inputConnection.openInputStream(), (String)PlayerWrapper.getMP3Type());
            this.p.addPlayerListener((PlayerListener)this);
            this.p.realize();
            try {
                this.vc = (VolumeControl)this.p.getControl("VolumeControl");
            }
            catch (Exception exception) {
                this.vc = null;
            }
            this.setVolume(this.volume);
        }
        catch (Exception exception) {
            this.stop();
        }
    }

    public boolean isStopped() {
        return this.p == null;
    }

    public static String getMP3Type() {
        if (mp3Type != null) {
            return mp3Type;
        }
        try {
            String[] stringArray = Manager.getSupportedContentTypes(null);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].toLowerCase().equals("audio/mp3")) continue;
                mp3Type = "audio/mp3";
                return "audio/mp3";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        mp3Type = "audio/mpeg";
        return "audio/mpeg";
    }

    public static boolean hasHTTPS() {
        if (hasHTTPS != null) {
            return hasHTTPS;
        }
        try {
            String[] stringArray = Manager.getSupportedProtocols(null);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].toLowerCase().indexOf("https") == -1) continue;
                hasHTTPS = Boolean.TRUE;
                return hasHTTPS;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hasHTTPS = Boolean.FALSE;
        return hasHTTPS;
    }

    public boolean isPlaying() {
        try {
            return this.p != null && this.p.getState() == 400;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean folderExists(String string) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)string, (int)3);
            boolean bl = fileConnection.exists() && fileConnection.isDirectory() && fileConnection.canWrite() && fileConnection.canRead();
            fileConnection.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long downloadFile(String string, FileConnection fileConnection, ProgressProvider progressProvider, int n) throws Exception {
        try {
            long l = PlayerWrapper._downloadFile(string, fileConnection, progressProvider, n);
            if (progressProvider != null) {
                if (l != 0L) {
                    progressProvider.successful();
                } else {
                    progressProvider.failed("File corrupted.");
                }
            }
            return l;
        }
        catch (Exception exception) {
            if (progressProvider != null) {
                progressProvider.failed(exception.toString());
            }
            throw exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long _downloadFile(String string, FileConnection fileConnection, final ProgressProvider progressProvider, int n) throws Exception {
        if (!fileConnection.canWrite()) {
            throw new Exception("Can't write");
        }
        if (fileConnection.exists()) {
            fileConnection.delete();
        }
        fileConnection.create();
        OutputStream outputStream = fileConnection.openOutputStream();
        DProgressProvider dProgressProvider = new DProgressProvider(){

            public void setProgress(long l) {
                if (progressProvider != null) {
                    progressProvider.setProgress(l);
                }
            }

            public void failed(String string) {
                this.failed = string;
                this.successful = false;
            }

            public void successful() {
                this.failed = null;
                this.successful = true;
            }

            public String getName() {
                if (progressProvider == null) {
                    return null;
                }
                return progressProvider.getName();
            }
        };
        long l = HTTPClient.downloadFile(string, outputStream, dProgressProvider, n);
        if (dProgressProvider.failed != null) {
            throw new Exception(dProgressProvider.failed);
        }
        if (fileConnection.fileSize() != l) {
            fileConnection.delete();
            if (n == -1 || n >= 5) throw new Exception("File corrupted.");
            PlayerWrapper._downloadFile(string, fileConnection, progressProvider, n + 1);
            return l;
        } else {
            if (progressProvider == null) return l;
            progressProvider.setProgress(100L);
        }
        return l;
    }

    public static abstract class DProgressProvider
    implements ProgressProvider {
        String failed;
        boolean successful;
    }

    public static interface PWListener {
        public void update();

        public void endOfMedia();
    }
}

